﻿/*
	makeStereoSound( src:String, target:MovieClip, newName:String, [newDepth:Number] );
	
	MINIMAL USAGE:
		#include "makeStereoSound.as"
		makeStereoSound( "songName", _root, "mySong" );
		mySong.play();
*/



makeStereoSound = function( src, target, newName, newDepth )
{
	var newDepth = (newDepth) ? newDepth : target.getNextHighestDepth();
	var _this = target.createEmptyMovieClip( newName, newDepth );
	_this.createEmptyMovieClip( "left_mc", 0 );		// container for leftSound's transforms
	_this.createEmptyMovieClip( "right_mc", 1 );		// container for rightSound's transforms
	_this.leftSound = new Sound();						// internal Sound object
	_this.rightSound = new Sound();						// internal Sound object
	_this.soundName = "";									// Linkage name
	_this.startAt = 0;											// 0 seconds
	_this.loops = 999999;										// loops indefinitely
	_this.stereoDelay = 0.02;								// 20 milliseconds
	_this.isPlaying = false;
	// Mimic Sound events		(these can be externally defined)
	_this.onID3 = function(){}
	_this.onLoad = function(){}
	_this.onSoundComplete = function(){}
	
	
	
	
	
	
	// FUNCTIONS
	_this.play = function( newLoops )
	{
		if( newLoops )
		{
			_this.loops = newLoops;
		}
		if((_this.startAt*1000) > _this.duration)
		{
			_this.startAt = 0;
		}
		
		// start right sound, 20 milliseconds sooner
		_this.rightSound.start( _this.startAt+_this.stereoDelay, _this.loops );
		// start left sound
		_this.leftSound.start( _this.startAt, _this.loops );
		_this.setChannels();
		_this.isPlaying = true;
	}// play()
	
	
	
	_this.stop = function()
	{
		// Remember where we left off
		_this.startAt = _this.leftSound.position / 1000;		// convert:  milliseconds -> seconds
		// Stop the sound
		_this.leftSound.stop( _this.soundName );				// probably stops ALL instances of this particular sound effect
		_this.rightSound.stop( _this.soundName );			// probably redundant
		_this.isPlaying = false;
	}// stop()
	
	
	
	_this.getVolume = function()
	{
		return _this.leftSound.getVolume();
	}// volume		(get)
	_this.setVolume = function( newVolume )
	{
		_this.leftSound.setVolume( newVolume );
		_this.rightSound.setVolume( newVolume );
	}// volume		(set)
	_this.addProperty( "volume", _this.getVolume, _this.setVolume );
	
	
	
	_this.getPosition = function()
	{
		return _this.leftSound.position;
	}// position	(get)
	_this.setPosition = function( newStart )
	{
		var wasPlaying = _this.isPlaying;
		_this.stop();
		_this.startAt = newStart;
		if( wasPlaying == true )
		{
			_this.play();
		}
	}// position	(set)
	_this.addProperty( "position", _this.getPosition, _this.setPosition );
	
	
	
	_this.getDuration = function()
	{
		return _this.leftSound.duration;
	}// duration	(get)
	_this.addProperty( "duration", _this.getDuration, null );
	
	
	
	// Set channels		(which speaker each sound object uses)
	_this.setChannels = function()
	{
		_this.rightSound.setPan( 100 );
		_this.leftSound.setPan( -100 );
	}// setChannels()
	
	
	
	// pass Sound events
	_this.passSoundEvents = function()
	{
		_this.leftSound.onID3 = function()
		{
			_this.broadcastMessage( "onID3" );
			_this.onID3();
		}
		_this.leftSound.onLoad = function( success )
		{
			_this.broadcastMessage( "onLoad" );
			_this.onLoad( success );
		}
		_this.leftSound.onSoundComplete = function()
		{
			_this.broadcastMessage( "onSoundComplete" );
			_this.onSoundComplete();
		}
	}// passSoundEvents()
	
	
	
	
	
	
	// SETUP
	_this.soundName = src;		// remember which sound is being played, for stop()
	_this.leftSound = new Sound( _this.left_mc );
	_this.leftSound.attachSound( src );
	_this.rightSound = new Sound( _this.right_mc );
	_this.rightSound.attachSound( src );
	
	AsBroadcaster.initialize( this );
	// Set channels		(which speaker each sound object uses)
	_this.setChannels();
	// pass sound events		(allows addListener(), which is not available in normal Sound objects)
	_this.passSoundEvents();
}// StereoSound